package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.PromotorDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Promotor;

/**
 * Ab0485s00ServiceImpl generated by UDA, 21-feb-2017 13:23:33.
 * 
 * @author UDA
 */

@Service(value = "promotorService")
public class PromotorServiceImpl implements PromotorService {

	@Autowired
	private PromotorDao ab0485s00Dao;

	/**
	 * Inserts a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Promotor add(Promotor ab0485s00) {
		return this.ab0485s00Dao.add(ab0485s00);
	}

	/**
	 * Updates a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Promotor update(Promotor ab0485s00) {
		return this.ab0485s00Dao.update(ab0485s00);
	}

	/**
	 * Finds a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the promotor
	 */
	public Promotor find(Promotor ab0485s00) {
		return (Promotor) this.ab0485s00Dao.find(ab0485s00);
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  List<Promotor>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the list
	 */
	public List<Promotor> findPromotorMaxFecAlta(Promotor ab0485s00) {
		return (List<Promotor>) this.ab0485s00Dao
				.findPromotorMaxFecAlta(ab0485s00);
	}

	/**
	 * Counts rows in the Promotor table.
	 * 
	 *  ab0485s00
	 *            Promotor
	 *  Long
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @return the long
	 */
	public long buscarHayPromotorPrincipal(Promotor ab0485s00) {
		return this.ab0485s00Dao.buscarHayPromotorPrincipal(ab0485s00);
	}

	/**
	 * Deletes a single row in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Promotor ab0485s00) {
		this.ab0485s00Dao.remove(ab0485s00);
	}

	/**
	 * Finds a list of rows in the Ab0485s00 table.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Promotor> findAll(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Promotor>) this.ab0485s00Dao.findAll(ab0485s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0485s00 table using like.
	 * 
	 *  ab0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0485s00>
	 *
	 * @param ab0485s00 the ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Promotor> findAllLike(Promotor ab0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Promotor>) this.ab0485s00Dao.findAllLike(ab0485s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0485s00Dao.removeMultiple(filterAb0485s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0485s00>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Promotor> filter(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Promotor> listaAb0485s00 = this.ab0485s00Dao.findAllLike(
				filterAb0485s00, jqGridRequestDto, false);
		Long recordNum = this.ab0485s00Dao.findAllLikeCount(
				filterAb0485s00 != null ? filterAb0485s00 : new Promotor(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Promotor>> reorderSelection = this.ab0485s00Dao
					.reorderSelection(filterAb0485s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Promotor>(jqGridRequestDto, recordNum,
					listaAb0485s00, reorderSelection);
		}
		return new JQGridResponseDto<Promotor>(jqGridRequestDto, recordNum,
				listaAb0485s00);
	}

	/**
	 * Searches rows in the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  searchAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param searchAb0485s00 the search ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Promotor>> search(Promotor filterAb0485s00,
			Promotor searchAb0485s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0485s00Dao.search(filterAb0485s00, searchAb0485s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Promotor filterAb0485s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0485s00Dao.reorderSelection(filterAb0485s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Promotor>> jerarquia(
			Promotor filterAb0485s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Promotor>> listaAb0485s00 = this.ab0485s00Dao
				.findAllLikeJerarquia(filterAb0485s00, jqGridRequestDto);
		Long recordNum = this.ab0485s00Dao.findAllLikeCountJerarquia(
				filterAb0485s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Promotor>>(jqGridRequestDto,
				recordNum, listaAb0485s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0485s00 table.
	 * 
	 *  filterAb0485s00
	 *            Ab0485s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0485s00>>
	 *
	 * @param filterAb0485s00 the filter ab 0485 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Promotor>> jerarquiaChildren(
			Promotor filterAb0485s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Promotor>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Promotor>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0485s00Dao.findAllChild(filterAb0485s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
